package nemosofts.voxradio.fragment.online;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ProgressBar;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.appcompat.widget.SearchView;
import androidx.core.view.MenuHost;
import androidx.core.view.MenuProvider;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentTransaction;
import androidx.nemosofts.utils.DeviceUtils;
import androidx.nemosofts.utils.NetworkUtils;
import androidx.recyclerview.widget.DefaultItemAnimator;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.google.ads.mediation.admob.AdMobAdapter;
import com.google.ads.mediation.facebook.FacebookMediationAdapter;
import com.google.android.gms.ads.AdLoader;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.nativead.NativeAd;

import java.util.ArrayList;

import nemosofts.voxradio.R;
import nemosofts.voxradio.activity.RadioByActivity;
import nemosofts.voxradio.adapter.AdapterCountries;
import nemosofts.voxradio.callback.Callback;
import nemosofts.voxradio.callback.Method;
import nemosofts.voxradio.dialog.DialogUtil;
import nemosofts.voxradio.executor.LoadCou;
import nemosofts.voxradio.fragment.search.FragmentSearchCountries;
import nemosofts.voxradio.interfaces.CountriesListener;
import nemosofts.voxradio.item.ItemCountries;
import nemosofts.voxradio.utils.helper.Helper;
import nemosofts.voxradio.utils.recycler.EndlessRecyclerViewScrollListener;

public class FragmentCountries extends Fragment {

    private Helper helper;
    private RecyclerView rv;
    private AdapterCountries adapterCountries;
    private ArrayList<ItemCountries> arrayList;
    private ProgressBar progressBar;
    private FrameLayout frameLayout;
    private Boolean isLoading = false;
    private String errorMsg = "";
    private String homeSecId = "";
    private int page = 1;
    private int nativeAdPos = 0;
    private Boolean isOver = false;
    private Boolean isScroll = false;
    private Boolean isFromHome = false;

    private AdLoader adLoader;
    private final ArrayList<NativeAd> arrayListNativeAds = new ArrayList<>();

    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View rootView = inflater.inflate(R.layout.fragment_latest, container, false);

        helper = new Helper(getActivity(), (position, type) -> openRadioByActivity(position));

        try {
            homeSecId = getArguments().getString("id");
            isFromHome = true;
        } catch (Exception e) {
            homeSecId = "";
            isFromHome = false;
        }

        arrayList = new ArrayList<>();

        progressBar = rootView.findViewById(R.id.pb);
        frameLayout = rootView.findViewById(R.id.fl_empty);
        rv = rootView.findViewById(R.id.rv);
        boolean isLandscape = DeviceUtils.isLandscape(requireContext());
        GridLayoutManager manager = new GridLayoutManager(requireContext(), isLandscape ? 6 : 3);
        manager.setSpanSizeLookup(new GridLayoutManager.SpanSizeLookup() {
            @Override
            public int getSpanSize(int position) {
                return (adapterCountries.getItemViewType(position) == -2 || adapterCountries.isHeader(position)) ? manager.getSpanCount() : 1;
            }
        });
        rv.setLayoutManager(manager);
        rv.setItemAnimator(new DefaultItemAnimator());
        setScrollListener(manager);

        if(Callback.getNativeAdShow()%2 != 0) {
            Callback.setNativeAdShow(Callback.getNativeAdShow() + 1);
        } else {
            Callback.setNativeAdShow(Callback.getNativeAdShow());
        }

        loadCategories();

        addMenuProvider();
        return rootView;
    }

    private void setScrollListener(GridLayoutManager manager) {
        if (Boolean.FALSE.equals(isFromHome)) {
            rv.addOnScrollListener(new EndlessRecyclerViewScrollListener(manager) {
                @Override
                public void onLoadMore(int p, int totalItemsCount) {
                    if (getActivity() == null){
                        return;
                    }
                    if (Boolean.TRUE.equals(isOver)) {
                        adapterCountries.hideHeader();
                        return;
                    }
                    if (Boolean.FALSE.equals(isLoading)) {
                        isLoading = true;
                        new Handler(Looper.getMainLooper()).postDelayed(() -> {
                            isScroll = true;
                            loadCategories();
                        }, 0);
                    }
                }
            });
        }
    }

    private void openRadioByActivity(int position) {
        if(adapterCountries.getItem(position) == null) {
            return;
        }
        Intent intent = new Intent(getActivity(), RadioByActivity.class);
        intent.putExtra("type",  requireActivity().getString(R.string.countries));
        intent.putExtra("id",arrayList.get(position).id());
        intent.putExtra("name", arrayList.get(position).name());
        requireActivity().startActivity(intent);
    }

    private void addMenuProvider() {
        MenuHost menuHost = requireActivity();
        menuHost.addMenuProvider(new MenuProvider() {
            @Override
            public void onCreateMenu(@NonNull Menu menu, @NonNull MenuInflater menuInflater) {
                menu.clear();
                menuInflater.inflate(R.menu.menu_search, menu);

                // Configure the search menu item
                MenuItem item = menu.findItem(R.id.menu_search);
                item.setShowAsAction(MenuItem.SHOW_AS_ACTION_COLLAPSE_ACTION_VIEW | MenuItem.SHOW_AS_ACTION_IF_ROOM);
                SearchView searchView = (SearchView) item.getActionView();
                if (searchView != null) {
                    searchView.setOnQueryTextListener(queryTextListener);
                }
            }

            @Override
            public boolean onMenuItemSelected(@NonNull MenuItem menuItem) {
                // Handle menu item selection if necessary
                return false;
            }
        }, getViewLifecycleOwner());
    }

    SearchView.OnQueryTextListener queryTextListener = new SearchView.OnQueryTextListener() {
        @Override
        public boolean onQueryTextSubmit(@NonNull String s) {
            Callback.setSearchItem(s.replace(" ", "%20"));
            FragmentSearchCountries fSearch = new FragmentSearchCountries();
            FragmentManager fm = getParentFragmentManager();
            FragmentTransaction ft = fm.beginTransaction();
            ft.setTransition(FragmentTransaction.TRANSIT_FRAGMENT_OPEN);
            ft.hide(getParentFragmentManager().getFragments().get(getParentFragmentManager().getBackStackEntryCount()));
            ft.add(R.id.fragment, fSearch, getString(R.string.search_countries));
            ft.addToBackStack(getString(R.string.search_countries));
            ft.commit();
            return true;
        }

        @Override
        public boolean onQueryTextChange(String s) {
            return false;
        }
    };

    private void loadCategories() {
        if (!NetworkUtils.isConnected(requireContext())) {
            errorMsg = getString(R.string.err_internet_not_connected);
            setEmpty();
            return;
        }

        String helperName = Boolean.TRUE.equals(isFromHome) ? Method.METHOD_HOME_DETAILS : Method.METHOD_COU;
        LoadCou loadCou = new LoadCou(new CountriesListener() {
            @Override
            public void onStart() {
                if (arrayList.isEmpty()) {
                    frameLayout.setVisibility(View.GONE);
                    rv.setVisibility(View.GONE);
                    progressBar.setVisibility(View.VISIBLE);
                }
            }

            @Override
            public void onEnd(String success, String verifyStatus, String message, ArrayList<ItemCountries> arrayListCou) {
                if (getActivity() == null) {
                    return;
                }
                if (success.equals("1")) {
                    loadCouEnd(verifyStatus, message, arrayListCou);
                } else {
                    try {
                        isOver = true;
                        adapterCountries.hideHeader();
                    } catch (Exception e) {
                        Log.e("FragmentCountries", "Error in FragmentCountries", e);
                    }
                    errorMsg = getString(R.string.err_server);
                    setEmpty();
                }
                progressBar.setVisibility(View.GONE);
                isLoading = false;
            }
        }, helper.getAPIRequest(helperName, page, homeSecId, "", "",
                "", "", "", "", "","","",
                "","", null));
        loadCou.execute();
    }

    private void loadCouEnd(String verifyStatus, String message, ArrayList<ItemCountries> arrayListCou) {
        if (verifyStatus.equals("-1")) {
            DialogUtil.verifyDialog(requireActivity(), getString(R.string.err_unauthorized_access), message, () -> {
            });
            return;
        }
        if (arrayListCou.isEmpty()) {
            isOver = true;
            errorMsg = getString(R.string.err_no_cat_found);
            setEmpty();
        } else {
            for (int i = 0; i < arrayListCou.size(); i++) {
                arrayList.add(arrayListCou.get(i));
                if (helper.canLoadNativeAds(requireContext(),Callback.PAGE_NATIVE_CAT)) {
                    int abc = arrayList.lastIndexOf(null);
                    if (nativeAdPos != 0 && ((arrayList.size() - (abc + 1)) % nativeAdPos == 0)) {
                        arrayList.add(null);
                    }
                }
            }
            page = page + 1;
            setAdapter();
        }
    }

    @SuppressLint("NotifyDataSetChanged")
    private void setAdapter() {
        if (Boolean.FALSE.equals(isScroll)) {
            adapterCountries = new AdapterCountries(getActivity(), arrayList, (itemCountries, position) -> helper.showInterAd(position, ""));
            rv.setAdapter(adapterCountries);
            setEmpty();
            loadNativeAds();
        } else {
            adapterCountries.notifyDataSetChanged();
        }
    }

    private void loadNativeAds() {
        if (helper.canLoadNativeAds(requireContext(),Callback.PAGE_NATIVE_CAT)
                && Callback.getAdNetwork().equals(Callback.AD_TYPE_ADMOB)
                || Callback.getAdNetwork().equals(Callback.AD_TYPE_META) && arrayList.size() >= 10) {

            AdLoader.Builder builder = new AdLoader.Builder(requireContext(), Callback.getAdmobNativeAdID());
            Bundle extras = new Bundle();
            AdRequest adRequest;
            if(Callback.getAdNetwork().equals(Callback.AD_TYPE_ADMOB)) {
                adRequest = new AdRequest.Builder()
                        .addNetworkExtrasBundle(AdMobAdapter.class, extras)
                        .build();
            } else {
                adRequest = new AdRequest.Builder()
                        .addNetworkExtrasBundle(AdMobAdapter.class, new Bundle())
                        .addNetworkExtrasBundle(FacebookMediationAdapter.class, extras)
                        .build();
            }
            adLoader = builder.forNativeAd(nativeAd -> {
                try {
                    arrayListNativeAds.add(nativeAd);
                    if (!adLoader.isLoading() && adapterCountries != null) {
                        adapterCountries.addAds(arrayListNativeAds);
                    }
                } catch (Exception e) {
                    Log.e("FragmentCountries", "Error in loadNativeAds", e);
                }
            }).build();
            adLoader.loadAds(adRequest, 5);
        }
    }

    public void setEmpty() {
        if (!arrayList.isEmpty()) {
            rv.setVisibility(View.VISIBLE);
            frameLayout.setVisibility(View.GONE);
            progressBar.setVisibility(View.GONE);
        } else {
            rv.setVisibility(View.GONE);
            frameLayout.setVisibility(View.VISIBLE);
            progressBar.setVisibility(View.INVISIBLE);

            frameLayout.removeAllViews();
            LayoutInflater inflater = (LayoutInflater) requireActivity().getSystemService(Context.LAYOUT_INFLATER_SERVICE);

            @SuppressLint("InflateParams") View myView = inflater.inflate(R.layout.row_empty, null);

            TextView textView = myView.findViewById(R.id.tv_empty_msg);
            textView.setText(errorMsg);

            myView.findViewById(R.id.ll_empty_try).setOnClickListener(v -> {
                myView.findViewById(R.id.iv_empty).setVisibility(View.GONE);
                myView.findViewById(R.id.pb_empty).setVisibility(View.VISIBLE);
                new Handler().postDelayed(() -> {
                    myView.findViewById(R.id.iv_empty).setVisibility(View.VISIBLE);
                    myView.findViewById(R.id.pb_empty).setVisibility(View.GONE);
                    loadCategories();
                }, 500);
            });

            frameLayout.addView(myView);
        }
    }
}